/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.Util;

public class ClientScriptData
extends BaseScriptData {
    public boolean loadDefault = false;
    public ScriptContainer script = null;
    public final Data storedData = new Data();

    @Override
    public void clear() {
        this.script.clear();
    }

    private void createScript() {
        if (this.script == null) {
            this.script = new ScriptContainer(this, true);
        }
    }

    @Override
    public List<ScriptContainer> getScripts() {
        if (this.script == null) {
            this.createScript();
        }
        return Collections.singletonList(this.script);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && this.script != null;
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("Client Scripts ");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a(super.noticeString(type, event));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        if (this.script == null) {
            this.createScript();
        }
        this.script.clear();
        this.script.readFromNBT(compound.func_74775_l("Scripts"), true);
        this.scriptLanguage = Util.instance.deleteColor(compound.func_74779_i("ScriptLanguage"));
        this.enabled = compound.func_74767_n("ScriptEnabled");
        this.runScript(EnumScriptType.INIT.function, new PlayerEvent.InitEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)CustomNpcs.proxy.getPlayer())));
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onClientInit(this);
            }
        }
        if (this.script == null) {
            this.createScript();
        }
        this.script.run(type, event);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.script == null) {
            this.createScript();
        }
        compound.func_74782_a("Scripts", (NBTBase)this.script.writeToNBT(new NBTTagCompound()));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    public void loadDefaultScripts() {
        if (this.loadDefault) {
            return;
        }
        File saveDir = new File(CustomNpcs.Dir, "client_default");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        ScriptController.Instance.compound = new NBTTagCompound();
        File sData = new File(saveDir, "world_data.json");
        try {
            if (!sData.exists()) {
                Util.instance.saveFile(sData, new NBTTagCompound());
            } else {
                ScriptController.Instance.compound = NBTJsonUtil.LoadFile(sData);
            }
            LogWriter.debug("Load default client stored data - done");
        }
        catch (Exception e) {
            LogWriter.error("Error Default loading: " + sData.getName(), e);
        }
        this.storedData.setNbt(ScriptController.Instance.compound);
        String language = this.getLanguage().toLowerCase();
        saveDir = new File(saveDir, language);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        ScriptController.Instance.clients.clear();
        ScriptController.Instance.clientSizes.clear();
        ScriptController.Instance.loadDir(saveDir, "", ScriptController.Instance.languages.get(Util.instance.deleteColor(this.getLanguage())), false, true);
        LogWriter.debug("Load default client modules - " + ScriptController.Instance.clients.size());
        saveDir = new File(CustomNpcs.Dir, "client_default");
        File file = new File(saveDir, "client_scripts.json");
        try {
            if (!file.exists()) {
                if (this.script == null) {
                    this.enabled = true;
                    this.script = new ScriptContainer(this, true);
                }
                Util.instance.saveFile(file, this.writeToNBT(new NBTTagCompound()));
                LogWriter.debug("Create default client scripts - done");
            } else {
                NBTTagCompound nbt = NBTJsonUtil.LoadFile(file);
                if (nbt.func_150297_b("Constants", 10) || nbt.func_150297_b("Functions", 9)) {
                    NBTTagCompound constants = new NBTTagCompound();
                    constants.func_74782_a("Constants", (NBTBase)nbt.func_74775_l("Constants"));
                    constants.func_74782_a("Functions", (NBTBase)nbt.func_150295_c("Functions", 8));
                    ScriptController.Instance.constants = constants;
                }
                ScriptContainer.reloadConstants();
                this.script = new ScriptContainer(this, true);
                this.readFromNBT(nbt);
                LogWriter.debug("Load default client scripts - done: " + nbt.func_74775_l("Scripts").toString().length() + " size.");
            }
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.INIT, (Event)new PlayerEvent.InitEvent(null));
        }
        catch (Exception e) {
            LogWriter.error("Error Default loading: " + file.getName(), e);
        }
        this.loadDefault = true;
    }

    public void saveDefaultScripts() {
        File saveDir = new File(CustomNpcs.Dir, "client_default");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        try {
            Util.instance.saveFile(new File(saveDir, "world_data.json"), ScriptController.Instance.compound.func_74737_b());
            LogWriter.debug("Save Default Client stored data - done");
        }
        catch (Exception e) {
            LogWriter.error("Error Default saving: \"world_data.json\"", e);
        }
        if (!ScriptController.Instance.clients.isEmpty()) {
            String language = this.getLanguage().toLowerCase();
            if (!(saveDir = new File(saveDir, language)).exists()) {
                saveDir.mkdirs();
            }
            for (String name : ScriptController.Instance.clients.keySet()) {
                try {
                    File f = new File(saveDir, name);
                    if (!f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    Util.instance.saveFile(new File(saveDir, name), ScriptController.Instance.clients.get(name));
                }
                catch (Exception e) {
                    LogWriter.error("Error Default saving: " + name, e);
                }
            }
            LogWriter.debug("Save Default Client modules - done");
        }
        if (this.script == null) {
            this.enabled = true;
            this.script = new ScriptContainer(this, true);
        }
        try {
            NBTTagCompound nbt = this.writeToNBT(new NBTTagCompound());
            NBTTagCompound constants = new NBTTagCompound();
            NBTTagList functions = new NBTTagList();
            if (!ScriptController.Instance.constants.func_82582_d()) {
                for (String key : ScriptController.Instance.constants.func_74775_l("Constants").func_150296_c()) {
                    constants.func_74782_a(key, ScriptController.Instance.constants.func_74775_l("Constants").func_74781_a(key));
                }
                for (NBTBase tag : ScriptController.Instance.constants.func_150295_c("Functions", 8)) {
                    functions.func_74742_a(tag);
                }
            }
            nbt.func_74782_a("Constants", (NBTBase)constants);
            nbt.func_74782_a("Functions", (NBTBase)functions);
            Util.instance.saveFile(new File(saveDir, "client_scripts.json"), nbt);
            LogWriter.debug("Save Default Client scripts - done");
        }
        catch (Exception e) {
            LogWriter.error("Error Default saving: \"client_scripts.json\"", e);
        }
        this.loadDefault = false;
    }

    @Override
    public boolean isEmpty() {
        return this.script == null || !this.script.hasScriptCode();
    }
}

